﻿using StokYonetimSistemi.Business;
using System;
using System.Windows.Forms;

namespace StokYonetimSistemi.WinFormsUI
{
    public partial class frmLogin : Form
    {
        private readonly KullaniciManager _kullaniciManager = new KullaniciManager();

        public frmLogin()
        {
            // Bu satır, formun görsel bileşenlerini (buton, textbox vb.) oluşturan
            // .Designer.cs dosyasındaki metodu çağırır. Çok önemlidir.
            InitializeComponent();
        }

        private void btnLogin_Click(object sender, EventArgs e)
        {
            string kullaniciAdi = txtKullaniciAdi.Text;
            string sifre = txtSifre.Text;

            if (string.IsNullOrEmpty(kullaniciAdi) || string.IsNullOrEmpty(sifre))
            {
                MessageBox.Show("Kullanıcı adı ve şifre boş bırakılamaz!", "Uyarı", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return;
            }

            // Not: Veritabanında en az bir kullanıcı ve hash'lenmiş şifresi olmalı!
            bool girisBasarili = _kullaniciManager.KullaniciDogrula(kullaniciAdi, sifre);

            if (girisBasarili)
            {
                MessageBox.Show("Giriş başarılı!", "Bilgi", MessageBoxButtons.OK, MessageBoxIcon.Information);

                // Ana formu oluştur ve göster
                frmAnasayfa anasayfa = new frmAnasayfa();
                anasayfa.Show();

                // Mevcut login formunu gizle
                this.Hide();
            }
            else
            {
                MessageBox.Show("Kullanıcı adı veya şifre hatalı!", "Hata", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
    }
}